#!/usr/bin/env python
import numpy as np
from analysis.observables import load_samples, compute_two_point_correlator, estimate_beta_function
import argparse

def main():
    p = argparse.ArgumentParser(description="Compute correlator & beta from samples")
    p.add_argument("--input",      required=True, help="HDF5 samples file")
    p.add_argument("--out-corr",   required=True, help="Output path for correlator.npy")
    p.add_argument("--out-beta",   required=True, help="Output path for beta.npy")
    args = p.parse_args()

    s = load_samples(args.input)
    C = compute_two_point_correlator(s)
    np.save(args.out_corr, C)

    # pick 5 points evenly spaced for slope estimate
    idxs = list(range(0, len(C), max(1, len(C)//5)))
    b = estimate_beta_function(C, idxs)
    np.save(args.out_beta, b)

    print(f"Saved correlator to {args.out_corr} and beta to {args.out_beta}")

if __name__ == "__main__":
    main()
